<?php
/* --------------------------------------------------------------
   ActionOverview.php 2024-07-23
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2018 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);


namespace Gambio\Admin\Modules\Logfiles\App\Actions;

use Gambio\Admin\Modules\Logfiles\Interfaces\LogfileServiceInterface;
use Gambio\Core\Application\Http\AbstractAction;
use Gambio\Core\Application\Http\Request;
use Gambio\Core\Application\Http\Response;

class ActionOverview extends AbstractAction
{
    private LogfileServiceInterface $logfileService;




    public function __construct(LogfileServiceInterface $logfileService)
    {
        $this->logfileService = $logfileService;
    }

    public function handle(Request $request, Response $response): Response
    {
        $logFiles = $this->logfileService->getLogFiles();

        return $response->withJson([
            'data' => $logFiles,
        ]);
    }
}